package cx.threeg.dcms.ui;

import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;

import cx.threeg.dcms.R;
import cx.threeg.dcms.core.Prefs;

public class SettingsFragment extends Fragment {

    private EditText keywords;
    private CheckBox reader, thumb, typo, input;

    @Override public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState){
        View v = inflater.inflate(R.layout.fragment_settings, container, false);
        keywords = (EditText)v.findViewById(R.id.keywords);
        reader = (CheckBox)v.findViewById(R.id.cbReader);
        thumb = (CheckBox)v.findViewById(R.id.cbThumb);
        typo = (CheckBox)v.findViewById(R.id.cbTypo);
        input = (CheckBox)v.findViewById(R.id.cbInput);
        keywords.setText(Prefs.getKeywordsRaw(getActivity()));
        reader.setChecked(Prefs.isReaderMode(getActivity()));
        thumb.setChecked(Prefs.showThumb(getActivity()));
        typo.setChecked(Prefs.enhancedTypo(getActivity()));
        input.setChecked(Prefs.enableInput(getActivity()));
        ((Button)v.findViewById(R.id.webLogin)).setOnClickListener(new View.OnClickListener(){ @Override public void onClick(View vv){ startActivity(new Intent(getActivity(), LoginActivity.class)); }});
        View.OnClickListener saver=new View.OnClickListener(){ @Override public void onClick(View vv){
            Prefs.setKeywords(getActivity(), keywords.getText().toString());
            Prefs.setReaderMode(getActivity(), reader.isChecked());
            Prefs.setShowThumb(getActivity(), thumb.isChecked());
            Prefs.setEnhancedTypo(getActivity(), typo.isChecked());
            Prefs.setEnableInput(getActivity(), input.isChecked());
        }};
        reader.setOnClickListener(saver); thumb.setOnClickListener(saver); typo.setOnClickListener(saver); input.setOnClickListener(saver);
        
        CheckBox nativeLayout = new CheckBox(getActivity());
        nativeLayout.setText("使用原生排版");
        ((ViewGroup) v.findViewById(R.id.keywords).getParent()).addView(nativeLayout);
        nativeLayout.setChecked(Prefs.useNativeLayout(getActivity()));
        nativeLayout.setOnClickListener(new View.OnClickListener() {
            @Override public void onClick(View v) { Prefs.setUseNativeLayout(getActivity(), ((CheckBox)v).isChecked()); }
        });
        return v;
    }
}
